// SR11000SampleDlg.h : header file
//

#pragma once


//*************+***************+***************+***************+***************+
#include "EditLogBox.h"			// OMR control and no relationship


#include "SkDvSrBaseApi.h"
#include "SkDvSr11000Api.h"
#include "SkDvSrSeriesErr.h"

#include "afxwin.h"
//*************+***************+***************+***************+***************+


// CSR11000SampleDlg dialog
class CSR11000SampleDlg : public CDialog
{
// Construction
public:
	CSR11000SampleDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_SR11000SAMPLE_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	//-----+-------+-------+-------+-------+-------+-------+-------+
	CEditLogBox m_EditLogBoxLog;
	CEditLogBox m_EditLogBoxData;

	virtual void OnOK();
	virtual void OnCancel();

	afx_msg void OnBnClickedButtonConnect();
	afx_msg void OnBnClickedButtonLayout();
	afx_msg void OnBnClickedButtonRead();
	afx_msg void OnBnClickedButtonCancel();
	afx_msg void OnBnClickedButtonDisconnect();

	afx_msg void OnTimer(UINT_PTR nIDEvent);
	bool	OmrDataReceive(void);

	void	ShowCount(SK_CONT_FEED_COUNT* pContFeedCount);
	char*	GetStatusMsg(SK_SHEET_RESULT* pSheetResult);

	SkDvHandle				m_hDevice;				// Device handle
	SK_DV_SR3500_INFO		m_DvInfo;				// Device information structure

	bool					m_blReading;			// Flag reading(For I am not to be read during the operation on the application)
	int						m_iDataCount;			// The number of processed data


	//-----+-------+-------+-------+-------+-------+-------+-------+
};
